var NUM_QUESTIONS = 4;
var TEST_PREFIX = "le";

var tempQuestions = parent.Toolbar.tempQuestions;
var questionsOnPage = parent.Toolbar.questionsOnPage;
if (tempQuestions == null)
{
	parent.Toolbar.locked = false;

	parent.Toolbar.questionsOnPage = new Array();
	parent.Toolbar.tempQuestions = new Array();
	for (var i=0;i<NUM_QUESTIONS;i++)
	{
		parent.Toolbar.tempQuestions[i] = new parent.Toolbar.Question();
		parent.Toolbar.tempQuestions[i].setAnswer(null);
	}
	tempQuestions = parent.Toolbar.tempQuestions;
	questionsOnPage = parent.Toolbar.questionsOnPage;
	
	for (var i=0;i<NUM_QUESTIONS;i++)
	{
		var temp = null;
		if ((temp = getVar(TEST_PREFIX + (i+1))) != null)
		{
			tempQuestions[i].setAnswer(temp);
		}
	}
	//////////////////////////
	// DEVELOPERS CODE HERE //
	//////////////////////////
	// questionsOnPage[] is an array that
	// keeps track of which question numbers
	// go with which test page.  This is 
	// necessary when there are more than one
	// question per test page.  
	// Example:
	//
	//    questionsOnPage[4] = "7,8,9";
	//
	// The example above specifies that test
	// page 5 contains test questions 7, 8 and 9.
	questionsOnPage[0] = "1";
	questionsOnPage[1] = "2";
	questionsOnPage[2] = "3";
	questionsOnPage[3] = "4";
	
	// tempQuestions[] is an array of Question
	// objects.  Each element in the array
	// corresponds to a test question.  You need to
	// specify what the correct answers are for
	// each test question.
	// Example:
	//
	//    tempQuestions[0].setCorrectAnswers(2);
	//
	// The example above specifies that test question
	// 1's correct answer is 2.
	tempQuestions[0].setCorrectAnswers(2);
	tempQuestions[1].setCorrectAnswers(1);
	tempQuestions[2].setCorrectAnswers(2);
	tempQuestions[3].setCorrectAnswers(1);

	/////////////////////////
	// END DEVELOPERS CODE //
	/////////////////////////
}

function questionIsComplete(questionNumber)
{
	var questionNumberArray = questionsOnPage[questionNumber-1].split(",");
	for (var i=0;i<questionNumberArray.length;i++)
	{
		if (tempQuestions[questionNumberArray[i]-1].getAnswer() == "")
		{
			return false;
		}
	}
	
	return true;
}

function allQuestionsComplete()
{
	return (getIncompleteQuestionNumbers() == "");
}

function getIncompleteQuestionNumbers()
{
	temp = "";
	for (var i=0;i<questionsOnPage.length;i++)
	{
		if (!questionIsComplete(i+1))
		{
			temp += "," + (i+1);
		}
	}
	temp = temp.slice(1,temp.length);
	return temp;
}

function displayIncompleteMessage()
{
	var temp = "You must complete the entire test before locking in your scores.  The following questions have not been completed: ";
	temp += getIncompleteQuestionNumbers();
	temp += "\n\nYou must go back and complete these questions before your test can be locked in and scored.";
	
	alert(temp);
}

function getPercentage()
{
	var correct = 0;
	for (var i=0;i<tempQuestions.length;i++)
	{
		if (tempQuestions[i].isCorrect())
		{
			correct++;
		}
	}
	return (Math.round(correct/tempQuestions.length*100));
}
